<?php
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $name = trim($_POST['name']);
    $email = trim($_POST['email']);
    $message = trim($_POST['message']);

    if (empty($name) || empty($email) || empty($message)) {
        $error = "All fields are required!";
    } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $error = "Invalid email format!";
    } else {
        $to = "your-email@example.com";  // Your email address
        $subject = "New Contact Message from $name";
        $body = "You have received a new message from the contact form:\n\n".
                "Name: $name\n".
                "Email: $email\n\n".
                "Message:\n$message";
        $headers = "From: $email\r\n";
        $headers .= "Reply-To: $email\r\n";

        if (mail($to, $subject, $body, $headers)) {
            $success = "Thank you for your message! We will get back to you shortly.";
        } else {
            $error = "Oops! Something went wrong. Please try again later.";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Contact - Death's Nuggets</title>
  <link rel="stylesheet" href="style.css">
  <link rel="icon" href="favicon.ico" type="image/x-icon">
</head>
<body>

  <header>
    <div class="title">
      <h1>Death's Nuggets</h1>
    </div>
    <nav class="navbar">
      <ul>
        <li><a href="index.html">Home</a></li>
        <li><a href="menu.html">Menu</a></li>
        <li><a href="about.html">About</a></li>
        <li><a href="contact.php">Contact</a></li>
      </ul>
    </nav>
    <div class="logo">
      <img src="Images/log.png" alt="Death's Nuggets Logo" height="50">
    </div>
  </header>


  <footer>
    <p>&copy; 2024 Death's Nuggets. All rights reserved.</p>
    <p>Phone: (123) 456-7890 | Address: 123 Death St, Hot City, Spicyland</p>
    <div class="social-links">
      <a href="#">Facebook</a>
      <a href="#">Instagram</a>
      <a href="#">Twitter</a>
    </div>
  </footer>

</body>
</html>
